<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Settings extends CI_Controller {

	/**
	 * Settings Controller
	 *
	 */
	function __construct() {
		
		parent::__construct();
		session_set_cookie_params(0,'/settings',DIRECT_DOMAIN,TRUE,TRUE);
		session_start();
		
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		
		//if user is not authenticated, redirect to auth page, otherwise proceed to load controller
		if($this->session->userdata("is_loggedin") != "true") { $this->session->sess_destroy(); session_destroy(); redirect("auth/logout"); }
		
		//prev last activity update set to current last activity so we can reset it for functions we don't want to consider "activity"
		if(strlen($this->session->userdata('app_last_activity')) > 0) { $this->session->set_userdata('prev_last_activity',$this->session->userdata('app_last_activity')); }
		//if last activity not yet set, set it to current time
		else { $this->session->set_userdata('app_last_activity',time()); }
		
        //check if it the user needs to be logged out due to inactivity
        if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }    
        //update the last activity for the timeout
		else { $this->session->set_userdata('app_last_activity',time()); }
		
		//check if user has been removed since last page load
		$this->load->database();
		$user_exists = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
		//only destroy session if query successfully shows that the user no longer exists among active users
		if($user_exists) { if($user_exists->num_rows() < 1 || $user_exists->num_rows() > 1) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); } }
		
		$this->load->library("form_validation");
		$this->form_validation->set_error_delimiters('', '');
		$this->load->library("encrypt");
		$ldapconfig["user"] = $this->session->userdata("username");
		$ldapconfig["pwd"] = $this->encrypt->decode($this->session->userdata("ep"));
		$this->load->library("ldap",$ldapconfig);	
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$this->session->userdata('username').','.LDAP_ACCOUNTS_DN);
		$this->session->set_userdata('group_mailboxes',$group_mailboxes);		
		
		$user_timezone = $this->get_user_timezone();
		if($user_timezone) {
			date_default_timezone_set($user_timezone);
		}
	}
	
	public function index()
	{	
		$data = $this->get_user_ldap_info();
		
		//load theme info into view data
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
			
		$data["title"] = PORTAL_TITLE_PREFIX . "User Settings";
		$this->load->view("settings/index",$data);
	}
	
	public function notifications()
	{	
		$this->load->database();
		$data = $this->get_user_db_info();
		
		//load theme info into view data
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
			
		$data["title"] = PORTAL_TITLE_PREFIX . "User Settings";
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if($this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		//load view
		$this->load->view("settings/notifications",$data);
	}
	
	public function application() {
		$this->load->database();
		$this->load->library('locale');
		$data['countries'] = $this->locale->get_countries();
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_id='.$this->db->escape($this->get_user_id($this->session->userdata('username'))));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			if(isset($locale['country']) && strlen($locale['country']) > 0) {
				$timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $locale['country']);
			}
			else {
				$timezones = DateTimeZone::listIdentifiers();
			}
			$data['timezones'] = array();
			foreach($timezones as $timezone) {;
				$timezone_obj = new DateTimeZone($timezone);
				$gmt = new DateTimeZone('GMT');
				$time = new DateTime('now',$gmt);
				$offset = $timezone_obj->getOffset($time) / 3600;
				//print_r(timezone_abbreviations_list());
				$tmp['offset'] = $offset;
				$tmp['timezone'] = $timezone;
				
				array_push($data['timezones'],$tmp);
			}
			usort($data['timezones'],array("Settings","timezone_cmp")); //sort timezone array
			$data['current_country'] = $locale['country'];
			$data['current_timezone'] = $this->locale->get_timezone_from_id($locale['timezone']);
		}
		else {
			$data['timezones'] = DateTimeZone::listIdentifiers();
		}
		
		//load theme info into view data
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
			
		$data["title"] = PORTAL_TITLE_PREFIX . "Application Settings";
		$this->load->view('settings/application',$data);
	}
	
	public function ajax_timezone_list($country = NULL) {
		if(!isset($country)) { return FALSE; }
		$timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country);
		
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_id='.$this->db->escape($this->get_user_id($this->session->userdata('username'))));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			$current_timezone = $this->locale->get_timezone_from_id($locale['timezone']);
		}
		
		$options = array();
		foreach($timezones as $timezone) {
			$timezone_obj = new DateTimeZone($timezone);
			$time = new DateTime('now',$timezone_obj);
			$offset = $timezone_obj->getOffset($time) / 3600;
			
			$option_array['offset'] = $offset;
			$option_array['value'] = $timezone;
			$option_array['text'] = str_replace('_',' ',$timezone) . ' ' . '(GMT ' . ($offset < 0 ? $offset : '+'.$offset) . ':00) '. $this->locale->timezone_abbr_from_name($timezone);

			//mark current timezone as selected if necessary
			if(isset($current_timezone) && $current_timezone == $timezone) { $option_array['selected'] = TRUE; }
			else { $option_array['selected'] = FALSE;}
			//add to array of timezone options
			array_push($options,$option_array);
		}
		//sort timezone array
		usort($options,array("Settings","timezone_cmp"));
		//don't give this information out unless it was requested by ajax
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') { echo json_encode($options); }
	}
	
	public function update_app_settings() {
		$this->load->database();
		//get post values
		$country = $this->input->post('country',TRUE);
		$timezone = $this->input->post('timezone',TRUE);
		//set locale settings
		$this->load->library('locale');
		$locale['country'] = $country;
		$locale['timezone'] = $this->locale->get_id_from_timezone($timezone);
		$this->db->query('UPDATE users SET user_locale='.$this->db->escape(serialize($locale)).' WHERE user_id='.$this->db->escape($this->get_user_id($this->session->userdata('username'))));
		
		$this->session->set_flashdata('message_class','success');
		$this->session->set_flashdata('message','Locale settings successfully updated.');
		redirect('settings/application');
	}
	
	public function update_account_info() {
		$this->form_validation->set_rules("first_name","First Name","required","xss_clean");
		$this->form_validation->set_rules("last_name","Last Name","required","xss_clean");
		
		if($this->form_validation->run() == true) {			
			//capture input
			$first = $this->input->post("first_name",TRUE);
			$last = $this->input->post("last_name",TRUE);
			$middle = $this->input->post("middle_name",TRUE);
			$title = $this->input->post("title",TRUE);
			$department = $this->input->post("department",TRUE);
			$organization = $this->input->post("organization",TRUE);
			$telephone = $this->input->post("telephone",TRUE);
			$mobile = $this->input->post("mobile",TRUE);
			$location = $this->input->post("location",TRUE);
			
			$attributes = array();
			//add mandatory attrs to array
			$attributes["givenName"] = $first;
			$attributes["sn"] = $last;
			$attributes["cn"] = $first . " " . $last;
			
			//deal with optional attributes (middle name is a sepcial case, since we need to change displayName based on it too)
			if(isset($middle) && strlen($middle) > 0) { $attributes["initials"] = $middle; $attributes["displayName"] = $last . ", " . $first . " " . $middle; }
			else { $attributes["initials"] = ""; $attributes["displayName"] = $last . ", " . $first; }
			if(isset($title)) { $attributes["title"] = $title; }
			if(isset($department)) { $attributes["departmentnumber"] = $department; }
			if(isset($organization)) { $attributes["o"] = $organization; }
			if(isset($telephone)) { $attributes["telephonenumber"] = $telephone; }
			if(isset($mobile)) { $attributes["mobile"] = $mobile; }
			if(isset($location)) { $attributes["physicaldeliveryofficename"] = $location; }
			
			$modified = $this->ldap->modify_ldap_account($this->session->userdata("username"),$attributes);
			if($modified) {
				$this->session->set_flashdata('message','Account information successfully updated.');
				$this->session->set_flashdata('message_class','success');
				
				//if we reach this point presumably it was successful
				$this->session->set_userdata('user_cn',$attributes['cn']); //update user's name in session
				$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
				if($get_actor_id) {
					$actor_id_row = $get_actor_id->row_array();
					$actor_id = $actor_id_row["user_id"];
					$target_id = $actor_id;
					$this->load->library("audit");
					$this->audit->log_event("edit",array($target_id,$actor_id,"Update user information",date('U')));
				}
				redirect('settings');
			}
			else {
				$this->session->set_flashdata('message_class','error');
				$this->session->set_flashdata('message','Account information failed to update.');
				redirect('settings');
			}
		}
		else {
			$first_name_error = (strlen(form_error('first_name')) > 0) ? form_error('first_name') : null;
			$last_name_error = (strlen(form_error('last_name')) > 0) ? form_error('last_name') : null;
			$validation_errors = array('first_name'=>$first_name_error,'last_name'=>$last_name_error);
			$this->session->set_flashdata('validation_errors',$validation_errors);
			redirect('settings');
		}
	}
	
	public function update_notifications() {
		$this->load->database();
		
		$this->form_validation->set_rules("ext_mail","External Email","required|valid_email","xss_clean");
		if($this->form_validation->run() == true) {
			$get_user_id = $this->db->query("SELECT user_id FROM users WHERE user_name=" . $this->db->escape($this->session->userdata("username")));
			if($get_user_id) { 
				if($get_user_id->num_rows == 1) { 
					$row = $get_user_id->row_array();
					$user_id = $row["user_id"];
				}
			}
			if(isset($user_id)) {
				$ext_mail = $this->input->post("ext_mail",TRUE);
				if(array_key_exists("notify",$this->input->post(NULL,TRUE)) && array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				
				//if we reach this point presumably it was successful
				$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
				if($get_actor_id) {
					$actor_id_row = $get_actor_id->row_array();
					$actor_id = $actor_id_row["user_id"];
					$target_id = $actor_id;
					$this->load->library("audit");
					$this->audit->log_event("edit",array($target_id,$actor_id,"Update user information",date('U')));
				}
				$this->session->set_flashdata('message_class', 'success');
				$this->session->set_flashdata('message', 'Settings successfully updated.');
				redirect('settings/notifications');
			}
			else {
				$this->session->set_flashdata('message_class', 'error');
				$this->session->set_flashdata('message', 'Failed to update settings.');
				redirect('settings/notifications');
			}
		}
		else {
			$ext_mail_error = (strlen(form_error('ext_mail')) > 0) ? form_error('ext_mail') : null;
			$validation_errors = array('ext_mail'=>$ext_mail_error);
			$this->session->set_flashdata('validation_errors',$validation_errors);
			redirect('settings/notifications');
		}
	}
	
	private function ssha256_encode($text) {
		$salt = hash('sha256', openssl_random_pseudo_bytes(32));
		$hash = "{SSHA256}".base64_encode(pack("H*",hash('sha256',$text.$salt)).$salt);
		return $hash;
	}
	
	private function get_user_db_info() {
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if($this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		
		$get_mail = $this->db->query("SELECT user_mail,user_ext_notify_flag,user_ext_group_notify_flag FROM users WHERE user_name=" . $this->db->escape($this->session->userdata("username")));
		if($get_mail) { 
			if($get_mail->num_rows == 1) { 
				$row = $get_mail->row_array();
				$data["ext_mail"] = $row["user_mail"];
				$data["notify"] = $row["user_ext_notify_flag"];
				$data['group_notify'] = $row['user_ext_group_notify_flag'];
				return $data;
			}
			else { return FALSE; }
		}
		else { return FALSE; }
	}
	
	private function get_user_ldap_info() {
		if($this->ldap->connected()) {
				$properties = array("givenname","sn","initials","o","departmentnumber","telephonenumber","mobile","title","physicaldeliveryofficename");
				$filter = "(&(ObjectClass=person)(&(uid=" . $this->session->userdata("username") . ")))";
				$info = $this->ldap->search(NULL,1,$properties,$filter);
				if(count($info) > 0) {
				//set values that are mandatory
				$data["first"] = $info[0]["givenname"];
				$data["last"] = $info[0]["sn"];
				
				//optional values
				if(array_key_exists("initials",$info[0])) { $data["middle"] = $info[0]["initials"]; } else { $data["middle"] = ""; }
				if(array_key_exists("o",$info[0])) { $data["organization"] = $info[0]["o"]; } else { $data["organization"] = ""; }
				if(array_key_exists("title",$info[0])) { $data["jobtitle"] = $info[0]["title"]; } else { $data["jobtitle"] = ""; }
				if(array_key_exists("departmentnumber",$info[0])) { $data["department"] = $info[0]["departmentnumber"]; } else { $data["department"] = ""; }
				if(array_key_exists("telephonenumber",$info[0])) { $data["telephone"] = $info[0]["telephonenumber"]; } else { $data["telephone"] = ""; }
				if(array_key_exists("mobile",$info[0])) { $data["mobile"] = $info[0]["mobile"]; } else { $data["mobile"] = ""; }
				if(array_key_exists("physicaldeliveryofficename",$info[0])) { $data["location"] = $info[0]["physicaldeliveryofficename"]; } else { $data["location"] = ""; }	
				
				return $data;
				}
				else { return FALSE; }
		}
		else { return FALSE; }
	}
	
	private function get_user_timezone() {
		$this->load->database();
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_name='.$this->db->escape($this->session->userdata('username')));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			return $this->locale->get_timezone_from_id($locale['timezone']);
		}
		return FALSE;
	}
	
	private function get_user_id($username) {
		$get_id = $this->db->query('SELECT user_id FROM users WHERE user_name=' . $this->db->escape($username));
		if($get_id && $get_id->num_rows() == 1) {
			$get_id_row = $get_id->row_array();
			return $get_id_row['user_id'];
		}
		return FALSE;
	}
	
	public function timezone_cmp($arr_a,$arr_b) {
		if($arr_a['offset'] > $arr_b['offset']) { return -1; }
		else if($arr_a['offset'] < $arr_b['offset']) { return 1; }
		else if($arr_a['offset'] == $arr_b['offset']) { return 0; }
	}
}

/* End of file settings.php */
/* Location: ./application/controllers/settings.php */
